const About = require('../models/about')
const _ = require('lodash')

exports.getContentById = (req, res, next, id) => {
    About.findById(id)
        .exec((err, about) => {
            if (err || !about) {
                return res.status(404).json({ message: 'Content not found!' })
            }
            req.about = about
            next()
        })
}

exports.getContent = (req, res) => {
    About.find()
        .exec((err, about) => {
            if (err || !about) {
                return res.status(404).json({ message: 'Unable to fetch data!' })
            }
            res.send(about)
        })
}

exports.createContent = (req, res) => {
    const about = new About(req.body)

    about.save((err, savedData) => {
        console.log(err)
        if (err) {
            return res.status(400).json({ message: 'Unable to save content!' })
        }
        res.send(savedData)
    })
}

exports.updateContent = (req, res) => {
    let about = req.about

    about = _.extend(about, req.body)

    about.save((err, about) => {
        if (err) {
            console.log(err);
            return res.status(400).json({
                message: 'Update t-shirt to db failed'
            })
        }
        res.json(about)
    })
}