const User = require('../models/user')
const { check, validationResult } = require("express-validator");
var jwt = require('jsonwebtoken')
var expressJwt = require('express-jwt');
const { response } = require('express');

const config = require('../config')
// const { result } = require('lodash')
const client = require("twilio")(config.accountSID, config.authToken)

exports.signup = (req, res) => {

    console.log(req.body);

    const errors = validationResult(req)
    if (!errors.isEmpty()) {
        return res.status(422).json({
            message: errors.array()[0].msg
        })
    }

    const user = new User(req.body)
    console.log(user);
    user.save((err, user) => {
        if (err) {
            console.log(err);
            return res.status(400).json({
                message: 'NOT able to save user in DB'
            })
        }
        res.json({
            name: user.name,
            email: user.email,
            id: user._id,
        })
    })
}

exports.signin = (req, res) => {
    const { email, password } = req.body

    const errors = validationResult(req)
    if (!errors.isEmpty()) {
        return res.status(422).json({
            message: errors.array()[0].msg
        })
    }

    User.findOne({ email }, (err, user) => {

        if (err || !user) {
            return res.status(400).json({
                message: "USER email does not exists"
            })
        }

        if (!user.authenticate(password)) {
            return res.status(401).json({
                message: "Email and password do not match"
            })
        }

        // create token
        const token = jwt.sign({ _id: user._id }, process.env.SECRET)
        //put token in cookie
        res.cookie('token', token, { expire: new Date() + 9999 })

        // send response to frontend
        const { _id, name, email, role } = user
        return res.json({ token, user: { _id, name, email, role } })
    })
}


exports.signout = (req, res) => {
    res.clearCookie('token')
    res.json({ message: 'user sign out success!' })
}

//protected routes
exports.isSignedIn = expressJwt({
    secret: process.env.SECRET,
    userProperty: 'auth'
})

//Custom middleware
exports.isAuthenticated = (req, res, next) => {
    let checker = req.profile && req.auth && req.profile._id == req.auth._id
    if (!checker) {
        res.status(403).json({
            message: "ACCESS DENIED"
        })
    }
    next()
}


exports.isAdmin = (req, res, next) => {
    if (req.profile.role === 0) {
        return res.status(403).json({
            message: "You are not an admin!"
        })
    }
    next()
}



/* User auth */



exports.userLogin = (req, res) => {
    const mobile = `+91${req.body.mobile}`
    // const mobile = `+968${req.body.mobile}`
    const channel = 'sms'

    client
        .verify
        .services(config.serviceID)
        .verifications
        .create({
            to: mobile,
            channel: channel
        })
        .then(result => res.send(result))
        .catch(err => res.send(err))
}


exports.verifyUser = (req, res) => {
    const { code } = req.body
    const mobile = `+968${req.body.mobile}`
    client
        .verify
        .services(config.serviceID)
        .verificationChecks
        .create({
            to: mobile,
            code: code
        })
        .then(result => {
            if (result.status !== 'approved') {
                res.send({ message: 'OTP is invalid!' })
                return
            }
            User.findOne({ mobile: req.body.mobile })
                .exec((err, user) => {

                    if (err || !user) {
                        const newUser = new User(req.body)
                        newUser.mobile = req.body.mobile

                        return newUser.save((er, u) => {
                            if (er || !u) {
                                console.log('er' + er);
                                return res.status(404).json({ message: 'Unable to save user!' })
                            }
                            const { _id, mobile, role } = u
                            const token = jwt.sign({ _id: _id }, process.env.SECRET)

                            return res.json({ token, user: { _id, mobile, role } })

                        })
                    }

                    //put token in cookie
                    // res.cookie('token', token, { expire: new Date() + 9999 })

                    const token = jwt.sign({ _id: user._id }, process.env.SECRET)

                    const { _id, mobile, role } = user
                    return res.json({ token, user: { _id, mobile, role } })

                })
        })
}


/*
 User.find({ mobile: mobile })
        .exec((err, user) => {
            if (err || !user) {
                return res.status(404).json({ message: 'User not exist!' })
            }
*/