const Brand = require('../models/brands')
const { deletePhoto } = require('../utils/utils')

exports.getBrandById = (req, res, next, id) => {
    Brand.findById(id)
        .exec((err, brand) => {
            if (err || !brand) {
                return res.status(404).json({ message: 'Brand not found!' })
            }
            console.log(brand);
            req.brand = brand
            next()
        })
}

exports.fetchBrands = (req, res) => {
    Brand.find()
        .exec((err, brands) => {
            if (err) {
                return res.status(400).json({ message: "Can't find brands!" })
            }
            res.send(brands)
        })
}

exports.createBrand = (req, res) => {
    if (!req.file) {
        return res.status(404).json({ message: "Can't get image!" })
    }
    const brand = new Brand()
    brand.name = req.file.filename
    brand.save((err, result) => {
        if (err) {
            return res.status(400).json({ message: "Can't save brand!" })
        }
        res.send(result)
    })
}

exports.deleteBrand = (req, res) => {
    const brand = req.brand
    brand.remove((err, result) => {
        if (err) {
            return res.status(400).json({ message: "Error while deleting image!" })
        }
        deletePhoto(result.name)
        res.send(result)
    })
}