const Category = require('../models/category')
const Product = require('../models/product')
const fs = require('fs')



exports.getCategoryById = (req, res, next, id) => {

    Category.findById(id)
        .exec((err, cate) => {
            if (err || !cate) {
                return res.status(400).json({
                    message: 'Category not found!'
                })
            }
            req.category = cate
            next()
        })
}

exports.createCategory = (req, res) => {
    const pel = req.files.photoLEng
    const pep = req.files.photoPEng
    const pal = req.files.photoLArb
    const pap = req.files.photoPArb
    if (!pel) {
        return res.status(400).json({ message: "Can't get english landscape Image!" })
    }
    if (!pep) {
        return res.status(400).json({ message: "Can't get english portrait Image!" })
    }
    if (!pal) {
        return res.status(400).json({ message: "Can't get arabic landscape Image!" })
    }
    if (!pap) {
        return res.status(400).json({ message: "Can't get arabic portrait Image!" })
    }
    req.body.photoLEng = pel[0].filename
    req.body.photoPEng = pep[0].filename
    req.body.photoLArb = pal[0].filename
    req.body.photoPArb = pap[0].filename
    const category = new Category(req.body)
    category.save((err, category) => {
        if (err) {
            console.log(err);
            return res.status(400).json({
                message: 'Not able to save category in DB'
            })
        }
        res.json({ category })
    })
}

exports.getCategory = (req, res) => {
    return res.json(req.category)
}

exports.getAllCategory = (req, res) => {
    Category.find()
        .exec((err, categories) => {
            if (err) {
                return res.status(400).json({
                    message: 'No category found!'
                })
            }
            res.json(categories)
        })
}

exports.updateCategory = (req, res) => {
    const photos = []
    const category = req.category
    // console.log(category);
    let pel = category.photoLEng
    let pep = category.photoPEng
    let pal = category.photoLArb
    let pap = category.photoPArb
    if (req.files.photoLEng) {
        photos.push(pel)
        pel = req.files.photoLEng[0].filename

    }
    if (req.files.photoPEng) {
        photos.push(pep)
        pep = req.files.photoPEng[0].filename

    }
    if (req.files.photoLArb) {
        photos.push(pal)
        pal = req.files.photoLArb[0].filename

    }
    if (req.files.photoPArb) {
        photos.push(pap)
        pap = req.files.photoPArb[0].filename

    }


    category.photoLEng = pel
    category.photoPEng = pep
    category.photoLArb = pal
    category.photoPArb = pap
    category.name = req.body.name
    category.arabicName = req.body.arabicName

    category.save((err, updatedCategory) => {
        if (err) {
            return res.status(400).json({
                message: 'Failed to update category'
            })
        }
        photos.forEach(photo => unlinkFile(photo))
        res.json(updatedCategory)
    })
}

exports.removeCategory = (req, res) => {
    const category = req.category;

    category.remove((err, category) => {
        if (err) {
            return res.status(400).json({
                message: 'Failed to delete this category'
            })
        }
        unlinkFile(category.photoLEng)
        unlinkFile(category.photoPEng)
        unlinkFile(category.photoLArb)
        unlinkFile(category.photoPArb)
        res.json({
            message: 'Successfully deleted'
        })

    })
}


exports.categoryProducts = (req, res) => {
    const category = req.category
    Product.find({ category: category._id })
        .select('photos name arabicName')
        .limit(3)
        .exec((err, products) => {
            if (err) {
                return res.status(400).json({ error: true, message: 'Something went wrong!' })
            }
            res.json({ category, products })
        })
}

const unlinkFile = (name) => {
    fs.unlink(__basedir + '/uploads/' + name, (err) => {
        if (err) {
            console.log(err);
        };
        // console.log("data not found");
    });
}