var multer, storage, path, crypto;
multer = require('multer')
path = require('path');
crypto = require('crypto');

// Include the node file module
var fs = require('fs');

storage = multer.diskStorage({
    destination: './uploads/',
    filename: function (req, file, cb) {
        return crypto.pseudoRandomBytes(16, function (err, raw) {
            if (err) {
                return cb(err);
            }
            return cb(null, "" + (raw.toString('hex')) + (path.extname(file.originalname)));
        });
    }
});


var upload = multer({ storage: storage });
// console.log('upload :  ', upload);
module.exports = upload;