const { Order, ProductCart } = require('../models/order')
const _ = require('lodash')

exports.getOrderById = (req, res, next, id) => {
    Order.findById(id)
        .populate('products.product', 'name price')
        .exec((err, order) => {
            if (err) {
                return res.status(400).json({
                    error: 'No order found'
                })
            }
            req.order = order
            next()
        })
}

exports.createOrder = (req, res) => {
    console.log(req.body);
    req.body.user = req.profile._id
    const order = new Order(req.body)
    order.save((err, order) => {
        if (err) {
            return res.status(400).json({
                error: 'Failed to save your order!'
            })
        }
        res.json(order)
    })
}

exports.getAllOrders = (req, res) => {
    Order.find()
        .populate('user', '_id name')
        .sort([['createAt', 'desc']])
        .exec((err, order) => {
            if (err) {
                return res.status(400).json({
                    error: 'No orders found!'
                })
            }
            res.json(order)
        })
}

exports.getOrderDetails = (req, res) => {
    const order = req.order
    Order.find({ _id: order._id }).populate('user', '-role -purchase -updatedAt')
        .exec((err, orderData) => {
            if (err || !orderData) {
                return res.status(400).json({ error: true, message: 'Unable to find order detail!' })
            }
            res.send(orderData)

        })
}
exports.getOrderStatus = (req, res) => {
    res.json(Order.schema.path('status').enumValues)
}

exports.updateStatus = (req, res) => {
    let order = req.order
    order = _.extend(order, { status: req.body.status })

    order.save((err, updatedOrder) => {
        if (err) {
            return res.status(400).json({ error: true, message: 'Unable to update order status!' })
        }
        res.send(updatedOrder)
    })
}