const Review = require('../models/review')
const _ = require('lodash')


exports.getReviewById = (req, res, next, id) => {
    Review.findById(id)
        .exec((err, review) => {
            if (err || !review) {
                return res.status(404).json({ message: 'Review not found!' })
            }
            req.review = review
            next()
        })
}

exports.updateProductReview = (req, res, next) => {
    let product = req.product

    Review.find({ product: product._id })
        .select('-_id rating')
        .exec((err, rating) => {
            if (err) {
                return res.status(400).json({ error: true, message: 'Can\'t fetch rating!' })
            }
            let totalRate = 0
            rating.forEach((r) => totalRate = totalRate + r.rating)
            avgRate = (totalRate + req.body.rating) / (rating.length + 1)
            product = _.extend(product, { avgRating: avgRate.toFixed(1) })

            product.save((err, product) => {
                if (err || !product) {
                    return res.status(400).json({ error: true, message: 'Can\'t rate product' })
                }
                req.product = product
                next()
            })
        })

}

exports.getAllReviews = (req, res) => {
    Review.find()
        .exec((err, reviews) => {
            if (err) {
                return res.status(400).json({ error: true, message: 'Can\'t fetch reviews' })
            }
            res.send(reviews)
        })
}

exports.getProductReview = (req, res) => {
    const productId = req.params.productId
    Review.find({ product: productId })
        .populate('user', 'name createdAt')
        .exec((err, review) => {
            if (err) {
                return res.status(400).json({ error: true, message: 'Can\'t fetch review!' })
            }
            res.send(review)
        })
}

exports.createReview = (req, res) => {
    const review = new Review(req.body)
    review.save((err, result) => {
        if (err) {
            return res.status(400).json({ message: 'Review not saved!' })
        }
        res.send(result)
    })
}

exports.updateReview = (req, res) => {
    let review = req.review
    /* review.product = req.body.product
    review.user = req.body.user
    review.rating = req.body.rating
    review.review = req.body.review
    review.arabicReview = req.body.arabicReview
    review.likes = req.body.likes
    review.dislikes = req.body.dislikes */
    review = _.extend(review, req.body)

    review.save((err, updatedReview) => {
        if (err || !updatedReview) {
            return res.status(400).json({ message: 'Failed to update review!' })
        }
        res.send(updatedReview)
    })
}

exports.deleteReview = (req, res) => {
    const review = req.review
    review.remove((err, deletedReview) => {
        if (err || !deletedReview) {
            return res.status(400).json({ message: 'Failed to delete review!' })
        }
        res.send(deletedReview)
    })
}