const Slider = require('../models/slider')
const fs = require('fs')

exports.getSliderById = (req, res, next, id) => {
    Slider.findById(id)
        .exec((err, slider) => {
            if (err || !slider) {
                return res.status(400).json({
                    message: 'Slider not found!'
                })
            }
            req.slider = slider
            next()
        })
}

exports.getAllSliders = (req, res) => {
    Slider.find()
        .exec((err, sliders) => {
            if (err) {
                return res.status(400).json({
                    message: 'No slider found!'
                })
            }
            res.json(sliders)
        })
}

exports.createSlider = (req, res) => {

    if (!req.files.photo) {
        return res.status(400).json({
            message: "Can't get slider english image!"
        })
    }
    if (!req.files.photoArabic) {
        return res.status(400).json({
            message: "Can't get slider arabic image!"
        })
    }
    req.body.photo = req.files.photo[0].filename
    req.body.photoArabic = req.files.photoArabic[0].filename
    const slider = new Slider(req.body)
    slider.save((err, slider) => {
        if (err) {
            return res.status(400).json({
                message: 'Not able to save slider'
            })
        }
        res.json({
            message: 'Slider created!',
            slider
        })
    })
}

exports.updateSlider = (req, res) => {
    const slider = req.slider
    let image = req.slider.photo
    let arabicImage = req.slider.photoArabic
    if (req.files.photo) {
        unlinkFile(image)
        image = req.files.photo[0].filename
    }
    if (req.files.photoArabic) {
        unlinkFile(arabicImage)
        arabicImage = req.files.photoArabic[0].filename
    }

    slider.photo = image
    slider.photoArabic = arabicImage
    slider.buttonTxt = req.body.buttonTxt
    slider.arabicButtonText = req.body.arabicButtonText
    slider.save((err, updatedSlider) => {
        if (err) {
            return res.status(400).json({
                message: 'Failed to update slider!'
            })
        }
        res.json({
            message: 'Slider updated!',
            updatedSlider
        })
    })
}
exports.deleteSlider = (req, res) => {
    const slider = req.slider
    slider.remove((err, slider) => {
        if (err) {
            return res.status(400).json({
                message: 'Failed to delete this slider!'
            })
        }
        if (slider.photo) {
            fs.unlink(__basedir + '/uploads/' + slider.photo, (err) => {
                if (err) {
                    console.log(err);
                }
            })
        }
        res.json({ message: 'Slider removed!' })
    })
}


unlinkFile = (fileName) => {
    if (fileName) {
        fs.unlink(__basedir + '/uploads/' + fileName, (err) => {
            if (err) {
                console.log(err);
            }
        })
    }
}