const Store = require('../models/store')
const _ = require('lodash')
const fs = require('fs')

exports.getStoreById = (req, res, next, id) => {
    Store.findById(id)
        .exec((err, store) => {
            if (err || !store) {
                return res.status(404).json({ message: 'Unable to find store!' })
            }
            req.store = store
            next()
        })
}

exports.getStores = (req, res) => {
    console.log('coming');
    Store.find()
        .exec((err, stores) => {
            if (err) {
                return res.status(400).json({ message: 'Unable to fetch stores!' })
            }
            res.send(stores)
        })
}

exports.createStore = (req, res) => {
    if (!req.file) {
        return res.status(404).json({ message: 'Store image not found!' })
    }
    const store = new Store(req.body)
    store.photo = req.file.filename
    store.save((err, savedStore) => {
        if (err || !savedStore) {
            return res.status(400).json({ message: 'Store not saved!' })
        }
        res.send({ savedStore, message: 'Store saved successfully!' })
    })
}

exports.updateStore = (req, res) => {
    let photo
    let store = req.store
    if (!req.file) {
        photo = store.photo
    } else {
        photo = req.file.filename
        deletePhoto(store.photo)
    }

    store = _.extend(store, req.body)
    store.photo = photo
    //save to the db
    store.save((err, store) => {
        if (err) {
            console.log(err);
            return res.status(400).json({
                message: 'Update t-shirt to db failed'
            })
        }
        res.json(store)
    })
}

exports.removeStore = (req, res) => {
    const store = req.store
    store.remove((err, removedStore) => {
        if (err || !removedStore) {
            return res.status(404).json({ message: 'Unable to delete this store!' })
        }
        deletePhoto(removedStore.photo)
        res.send({ removedStore, message: 'Store removed!' })
    })
}


deletePhoto = (name) => {
    console.log(name);
    fs.unlink(__basedir + '/uploads/' + name, (err) => {
        if (err) {
            console.log(err);
        };
        // console.log("data not found");
    });
}