const User = require('../models/user')
const Order = require('../models/order')

exports.getUserById = (req, res, next, id) => {
    User.findById(id)
        .exec((err, user) => {
            if (err || !user) {
                return res.status(400).json({
                    message: "No user found!"
                })
            }
            req.profile = user
            next()
        })
}

exports.getUser = (req, res) => {
    //TODO: get back here for password
    req.profile.salt = undefined
    req.profile.encry_password = undefined
    req.profile.createdAt = undefined
    req.profile.updatedAt = undefined
    return res.json(req.profile)
}

exports.getAllUsers = (req, res) => {
    User.find()
        .exec((err, users) => {
            if (err || !users) {
                return res.status(400).json({
                    message: "No users found"
                })
            }
            res.json(users)
        })
}

exports.updateUser = (req, res) => {
    console.log(req.body);
    User.findByIdAndUpdate(
        { _id: req.profile._id },
        { $set: req.body },
        { new: true, useFindAndModify: false },
        (err, user) => {
            if (err || !user) {
                return res.status(400).json({
                    message: 'You are not authorized to update this user'
                })
            }

            user.salt = undefined
            user.encry_password = undefined
            user.createdAt = undefined
            user.updatedAt = undefined
            res.json(user)
        }
    )
}


exports.userPurchaseList = (req, res) => {
    Order.find({ user: req.profile._id })
        .populate('user', '_id name')
        .exec((err, order) => {
            if (err) {
                return res.status(400).json({
                    message: 'No order in this account!'
                })
            }
            res.json(order)
        })
}

exports.pushOrderInPurchaseList = (req, res, next) => {
    let purchases = []
    req.body.order.products.forEach(product => {
        purchases.push({
            _id: product._id,
            name: product.name,
            description: product.description,
            category: product.category,
            quantity: product.quantity,
            amount: req.body.order.amount,
            transaction_id: req.body.order.transaction_id
        })
    });

    //store this in DB
    User.findOneAndUpdate(
        { _id: req.profile._id },
        { $push: { purchases: purchases } },
        { new: true },
        (err, purchases) => {
            if (err) {
                return res.status(400).json({
                    message: "Unable to save purchase list"
                })
            }
            next()
        }
    )
}