const mongoose = require('mongoose')

const categorySchema = new mongoose.Schema({
    name: {
        type: String,
        trim: true,
        require: true,
        maxlength: 32,
        unique: true
    },
    arabicName: {
        type: String,
        trim: true,
        require: true,
        maxlength: 32,
        unique: true
    },
    photoLEng: {
        type: String,
        required: true,
        trim: true
    },
    photoPEng: {
        type: String,
        required: true,
        trim: true
    },
    photoLArb: {
        type: String,
        required: true,
        trim: true
    },
    photoPArb: {
        type: String,
        required: true,
        trim: true
    }

}, { timestamps: true })

module.exports = mongoose.model('Category', categorySchema)