const mongoose = require('mongoose')
const { ObjectId } = mongoose.Schema

const productSchema = new mongoose.Schema({
    name: {
        type: String,
        trim: true,
        required: true,
    },
    arabicName: {
        type: String,
        trim: true,
        required: true,
    },
    description: {
        type: String,
        trim: true,
        required: true
    },
    arabicDescription: {
        type: String,
        trim: true,
        required: true
    },
    detail: {
        type: String,
        required: true
    },
    arabicDetail: {
        type: String,
        required: true
    },
    price: {
        type: Number,
        required: true,
        maxlength: 32,
        trim: true
    },
    listingPrice: {
        type: Number,
        trim: true
    },
    category: {
        type: ObjectId,
        ref: 'Category',
        required: true
    },
    stock: {
        type: Number,
        required: true
    },
    sold: {
        type: Number,
        default: 0
    },
    photos: {
        type: Array
    },
    productColor: {
        type: Array,
        required: true
    },
    productSize: {
        type: Array,
        required: true
    },
    onSale: {
        type: Boolean,
        default: false
    },
    isPopular: {
        type: Boolean,
        default: false
    },
    brandName: String,
    avgRating: {
        type: Number,
        default: 0
    }
}, { timestamps: true })

module.exports = mongoose.model('Product', productSchema)