const mongoose = require('mongoose')
const { ObjectId } = mongoose.Schema

const reviewSchema = new mongoose.Schema({
    product: {
        type: ObjectId,
        ref: 'Product',
        required: true
    },
    user: {
        type: ObjectId,
        ref: 'User',
        required: 'true'
    },
    rating: {
        type: Number,
        required: true
    },
    review: String,
    arabicReview: String,
    likes: Number,
    dislikes: Number
}, { timestamps: true })

module.exports = mongoose.model('Review', reviewSchema)