const mongoose = require('mongoose')
const { ObjectId } = mongoose.Schema

const sliderSchema = new mongoose.Schema({
    photo: {
        type: String,
        trim: true,
        required: true
    },
    photoArabic: {
        type: String,
        required: true
    },
    buttonTxt: {
        required: true,
        trim: true,
        type: String
    },
    arabicButtonText: {
        required: true,
        type: String,
        trim: true
    },
    category: {
        type: ObjectId,
        ref: 'Category'
    }
}, { timestamps: true })

module.exports = mongoose.model('Slider', sliderSchema)