const express = require('express')
const { createContent, getContentById, updateContent, getContent } = require('../controllers/about')
const router = express.Router()
const { isSignedIn, isAuthenticated, isAdmin } = require('../controllers/auth')
const { getUserById } = require('../controllers/user')

router.param('userId', getUserById)
router.param('aboutId', getContentById)

router.post('/about/create/:userId', isSignedIn, isAuthenticated, isAdmin, createContent)

//update route
router.put('/about/:aboutId/:userId', isSignedIn, isAuthenticated, isAdmin, updateContent)

//Listing routes
router.get('/about/content', getContent)



module.exports = router