const bodyParser = require('body-parser')
const express = require('express')
const { check, validationResult } = require('express-validator')
const router = express.Router()
router.use(bodyParser.json())
const { signup, signin, signout, isSignedIn, userLogin, verifyUser } = require('../controllers/auth')

router.post(
    "/signup",
    [
        check("name", "name should be at least 3 char").isLength({ min: 3 }),
        check("email", "email is required").isEmail(),
        check("password", "password should be at least 3 char").isLength({ min: 3 })
    ],
    signup
)
router.post(
    "/signin",
    [
        check("email", "email is required").isEmail(),
        check("password", "password should be at least 3 char").isLength({ min: 3 })
    ],
    signin
)
router.get('/signout', signout)
router.get('/testroute', isSignedIn, (req, res) => {
    res.json(req.auth)
})


/* User routes */
router.post('/user/login', userLogin)
router.post('/user/verify', verifyUser)
module.exports = router