const express = require('express')
const router = express.Router()
const imageUpload = require('../controllers/image.uploads')

const { getBrandById, fetchBrands, createBrand, deleteBrand } = require('../controllers/brands')
const { isSignedIn, isAdmin, isAuthenticated } = require('../controllers/auth')
const { getUserById } = require('../controllers/user')

router.param('userId', getUserById)
router.param('brandId', getBrandById)

//Actual routes
router.post('/brand/create/:userId', isSignedIn, isAuthenticated, isAdmin, imageUpload.single("photo"), createBrand)
router.get('/brands', fetchBrands)


//delete
router.delete('/brand/:brandId/:userId', isSignedIn, isAuthenticated, isAdmin, deleteBrand)



module.exports = router