const express = require('express')
const router = express.Router()
const imageUpload = require('../controllers/image.uploads')

const {
    getCategoryById,
    createCategory,
    getCategory,
    getAllCategory,
    updateCategory,
    removeCategory,
    categoryProducts
} = require('../controllers/category')
const { isSignedIn, isAdmin, isAuthenticated } = require('../controllers/auth')
const { getUserById } = require('../controllers/user')

router.param('userId', getUserById)
router.param('categoryId', getCategoryById)

//Image fields
const fields = [
    { name: 'photoLEng', maxCount: 1 },
    { name: 'photoPEng', maxCount: 1 },
    { name: 'photoLArb', maxCount: 1 },
    { name: 'photoPArb', maxCount: 1 },
]

//Actual routes
router.post('/category/create/:userId', isSignedIn, isAuthenticated, isAdmin, imageUpload.fields(fields), createCategory)
router.get('/category/:categoryId', getCategory)
router.get('/categories', getAllCategory)

//update
router.put('/category/:categoryId/:userId', isSignedIn, isAuthenticated, isAdmin, imageUpload.fields(fields), updateCategory)

//delete
router.delete('/category/:categoryId/:userId', isSignedIn, isAuthenticated, isAdmin, removeCategory)

//listing
router.get('/category/products/:categoryId', categoryProducts)

module.exports = router