const express = require('express')
const router = express.Router()
const { isSignedIn, isAuthenticated, isAdmin } = require('../controllers/auth')
const { getUserById, pushOrderInPurchaseList } = require('../controllers/user')
const { updateStock } = require('../controllers/products')

const { getOrderById, createOrder, getAllOrders, updateStatus, getOrderStatus, getOrderDetails } = require('../controllers/order')

// params
router.param('userId', getUserById)
router.param('orderId', getOrderById)

// actual routes
router.post('/order/create/:userId',
    isSignedIn,
    isAuthenticated,
    // pushOrderInPurchaseList,
    // updateStock,
    createOrder
)
router.get('/order/all/:userId', isSignedIn, isAuthenticated, isAdmin, getAllOrders)
router.get('/order/status/:userId', isSignedIn, isAuthenticated, isAdmin, getOrderStatus)
router.get('/order/:orderId/:userId', isSignedIn, isAuthenticated, isAdmin, getOrderDetails)
router.put('/order/:orderId/status/:userId', isSignedIn, isAuthenticated, isAdmin, updateStatus)



module.exports = router