const express = require('express')
const router = express.Router()
const imageUpload = require('../controllers/image.uploads')

const {
    createProduct,
    getProductById,
    getProduct,
    photo,
    deleteProduct,
    updateProduct,
    getAllProducts,
    getAllUniqueCategories,
    uploadImage,
    deleteProductImage,
    getPopularProducts,
    filterProducts,
    getRelatedProducts,
    filterOptions
} = require('../controllers/products')
const { isSignedIn, isAuthenticated, isAdmin } = require('../controllers/auth')
const { getUserById } = require('../controllers/user')

router.param('userId', getUserById)
router.param('productId', getProductById)

router.post('/product/create/:userId', isSignedIn, isAuthenticated, isAdmin, createProduct)
router.get('/product/:productId', getProduct)
router.get('/product/photo/:productId', photo)

//delete route
router.delete('/product/:productId/:userId', isSignedIn, isAuthenticated, isAdmin, deleteProduct)
router.delete('/deleteImage/:productId/:userId', isSignedIn, isAuthenticated, isAdmin, deleteProductImage)

//update route
router.put('/product/:productId/:userId', isSignedIn, isAuthenticated, isAdmin, updateProduct)
router.put('/uploadImages/:productId/:userId', isSignedIn, isAuthenticated, isAdmin, imageUpload.array("photos"), uploadImage)

//Listing routes
router.get('/products', getAllProducts)
router.get('/products/popular', getPopularProducts)
router.get('/filterOptions', filterOptions)
router.post('/products/filter', filterProducts)
router.post('/products/related', getRelatedProducts)

router.get('/products/categories', getAllUniqueCategories)


module.exports = router