const express = require('express')
const router = express.Router()
const { getReviewById, getAllReviews, createReview, updateReview, deleteReview, getProductReview, updateProductReview } = require('../controllers/review')
const { isSignedIn, isAdmin, isAuthenticated } = require('../controllers/auth')
const { getUserById } = require('../controllers/user')
const { getProductById } = require('../controllers/products')

router.param('userId', getUserById)
router.param('reviewId', getReviewById)
router.param('productId', getProductById)

//Actual routes
router.get('/reviews', getAllReviews)
router.get('/review/:productId', getProductReview)
router.post('/review/create/:productId/:userId', isSignedIn, isAuthenticated, updateProductReview, createReview)

//update
router.put('/review/:reviewId/:userId', isSignedIn, isAuthenticated, isAdmin, updateReview)

//delete
router.delete('/review/:reviewId/:userId', isSignedIn, isAuthenticated, isAdmin, deleteReview)



module.exports = router