const express = require('express')
const router = express.Router()
const imageUpload = require('../controllers/image.uploads')
const {
    getSliderById,
    getAllSliders,
    createSlider,
    updateSlider,
    deleteSlider
} = require('../controllers/slider')
const { isSignedIn, isAdmin, isAuthenticated } = require('../controllers/auth')
const { getUserById } = require('../controllers/user')

router.param('userId', getUserById)
router.param('sliderId', getSliderById)


//Actual routes
router.post('/slider/create/:userId', isSignedIn, isAuthenticated, isAdmin, imageUpload.fields([
    { name: 'photo', maxCount: 1 },
    { name: 'photoArabic', maxCount: 1 },
]), createSlider)
router.get('/sliders', getAllSliders)

//update
router.put('/slider/:sliderId/:userId', isSignedIn, isAuthenticated, isAdmin, imageUpload.fields([
    { name: 'photo', maxCount: 1 },
    { name: 'photoArabic', maxCount: 1 },
]), updateSlider)

//delete
router.delete('/slider/:sliderId/:userId', isSignedIn, isAuthenticated, isAdmin, deleteSlider)



module.exports = router