const express = require('express')
const router = express.Router()
const imageController = require('../controllers/image.uploads')
const { isSignedIn, isAuthenticated, isAdmin } = require('../controllers/auth')
const { getStoreById, getStores, createStore, updateStore, removeStore } = require('../controllers/store')
const { getUserById } = require('../controllers/user')

router.param('userId', getUserById)
router.param('storeId', getStoreById)

//Listing routes
router.get('/stores', getStores)

router.post('/store/create/:userId', isSignedIn, isAuthenticated, isAdmin, imageController.single('photo'), createStore)

//update route
router.put('/store/:storeId/:userId', isSignedIn, isAuthenticated, isAdmin, imageController.single('photo'), updateStore)

//delete route
router.delete('/store/:storeId/:userId', isSignedIn, isAuthenticated, isAdmin, removeStore)

module.exports = router